// PageSettingSipAndPlatform.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingSipAndPlatform.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "CommCtrl.h"

// CPageSettingSipAndPlatform dialog

IMPLEMENT_DYNAMIC(CPageSettingSipAndPlatform, CDialog)

CPageSettingSipAndPlatform::CPageSettingSipAndPlatform(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingSipAndPlatform::IDD, pParent)
{

}

CPageSettingSipAndPlatform::~CPageSettingSipAndPlatform()
{

}

void CPageSettingSipAndPlatform::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IPADDRESS_SIPSERVERIP, m_SIPserverIP);
	DDX_Control(pDX, IDC_EDIT_SIPSERVERPORT, m_EditSIPserverPort);
	DDX_Control(pDX, IDC_EDIT_SIPSERVERID, m_EditSIPserverID);
	DDX_Control(pDX, IDC_EDIT_SIPDEVICEID, m_EditSIPDeviceID);
	DDX_Control(pDX, IDC_EDIT_SIPUSERNAME, m_EditSIPUserName);
	DDX_Control(pDX, IDC_EDIT_SIPPWD, m_EditSIPPassword);
	DDX_Control(pDX, IDC_EDIT_SIPVALIDDATE, m_EditSIPRegValidity);
	DDX_Control(pDX, IDC_EDIT_SIPTIME, m_EditSIPKeepalive);
	DDX_Control(pDX, IDC_EDIT_SIPHEART, m_EditSIPHeartBeatInterval);
	DDX_Control(pDX, IDC_EDIT_HEARTNUM, m_EditSIPHeartBeatTimes);
	DDX_Control(pDX, IDC_CHECK_REGISTER, m_ChkSIPReg);
	DDX_Control(pDX, IDC_EDIT_CHANNELNO, m_EditSIPVideoChannelID);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_CboSIPVideoChannelNum);
	DDX_Control(pDX, IDC_LIST_PLATFORMINFO, m_ListPlatformInfo);
	DDX_Control(pDX, IDC_LIST_RUNNINGPLATFORM, m_ListRunning);
}


BEGIN_MESSAGE_MAP(CPageSettingSipAndPlatform, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETSIP, &CPageSettingSipAndPlatform::OnBnClickedButtonSetsip)
	ON_BN_CLICKED(IDC_BUTTON_SETCHANNEL, &CPageSettingSipAndPlatform::OnBnClickedButtonSetchannel)
	ON_BN_CLICKED(IDC_BUTTON_STARTPLATFORM, &CPageSettingSipAndPlatform::OnBnClickedButtonStartplatform)
	ON_BN_CLICKED(IDC_BUTTON_STOPPLATFORM, &CPageSettingSipAndPlatform::OnBnClickedButtonStopplatform)
	ON_BN_CLICKED(IDC_BUTTON_REFREASH, &CPageSettingSipAndPlatform::OnBnClickedButtonRefreash)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CPageSettingSipAndPlatform::OnCbnSelchangeComboChannel)
END_MESSAGE_MAP()


// CPageSettingSipAndPlatform message handlers
void  CPageSettingSipAndPlatform::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_SIPSERVERIP, GetText(IDS_SETTING_SIPSVERIP));
	SetDlgItemText(IDC_STATIC_SIPSERVERPORT, GetText(IDS_SETTING_SIPSVERPORT));
	SetDlgItemText(IDC_STATIC_SIPSERVERID, GetText(IDS_SETTING_SIPSVERID));
	SetDlgItemText(IDC_STATIC_SIPDEVICEID, GetText(IDS_SETTING_SIPDEVID));
	SetDlgItemText(IDC_STATIC_SIPUSERNAME, GetText(IDS_SETTING_SIPUSERNAME));
	SetDlgItemText(IDC_STATIC_SIPPWD, GetText(IDS_SETTING_SIPPWD));
	SetDlgItemText(IDC_STATIC_SIPVALIDDATE, GetText(IDS_SETTING_SIPREGVALIDITY));
	SetDlgItemText(IDC_STATIC_SIPTIME, GetText(IDS_SETTING_SIPKEEPALIVE));
	SetDlgItemText(IDC_STATIC_SIPHEART, GetText(IDS_SETTING_HEARTBEATINTERVAL));
	SetDlgItemText(IDC_STATIC_HEARTNUM, GetText(IDS_SETTING_SIPHEARTBEATTIMES));
	SetDlgItemText(IDC_CHECK_REGISTER, GetText(IDS_SETTING_CHECKSIPREG));
	SetDlgItemText(IDC_BUTTON_SETSIP, GetText(IDS_SETTING_SIPSET));

	SetDlgItemText(IDC_STATIC_CHANNEL, GetText(IDS_SETTING_SIPVIDEOCHANNEL));
	SetDlgItemText(IDC_STATIC_CHANNELNO, GetText(IDS_SETTING_SIPVIDEOLEVEL));
	SetDlgItemText(IDC_BUTTON_SETCHANNEL, GetText(IDS_SETTING_SETSIPVIDEOCHANNEL));

	SetDlgItemText(IDC_PLATFORMSVER, GetText(IDS_SETTING_PLATFORMSVER));
	SetDlgItemText(IDC_BUTTON_STARTPLATFORM, GetText(IDS_SETTING_SVERSTART));
	SetDlgItemText(IDC_BUTTON_STOPPLATFORM, GetText(IDS_SETTING_SVERSTOP));
	SetDlgItemText(IDC_BUTTON_REFREASH, GetText(IDS_SETTING_SVERREFRESH));
	m_ListPlatformInfo.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_ListRunning.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_ListPlatformInfo.InsertColumn(0, GetText(IDS_SETTING_PLATFORMSVERNAME),LVCFMT_LEFT, 200);
	m_ListRunning.InsertColumn(0, GetText(IDS_SETTING_PLATFORMSVERRUN),LVCFMT_LEFT, 200);


}

int CPageSettingSipAndPlatform::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	if (NULL != _pdecParam)
	{
		DecDzInfo Info = {0};
		Info.iSize = sizeof(DecDzInfo);
		int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DZ_INFO, &Info, Info.iSize);
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
			return -1;
		}
		m_SIPserverIP.SetWindowText((LPCTSTR)Info.tInfo.m_cParam1);
		m_EditSIPserverPort.SetWindowText((LPCTSTR)Info.tInfo.m_cParam2);
		m_EditSIPserverID.SetWindowText((LPCTSTR)Info.tInfo.m_cParam3);
		m_EditSIPDeviceID.SetWindowText((LPCTSTR)Info.tInfo.m_cParam4);
		m_EditSIPUserName.SetWindowText((LPCTSTR)Info.tInfo.m_cParam5);
		m_EditSIPPassword.SetWindowText((LPCTSTR)Info.tInfo.m_cParam6);
		m_EditSIPRegValidity.SetWindowText((LPCTSTR)Info.tInfo.m_cParam7);
		m_EditSIPKeepalive.SetWindowText((LPCTSTR)Info.tInfo.m_cParam8);
		m_EditSIPHeartBeatInterval.SetWindowText((LPCTSTR)Info.tInfo.m_cParam9);
		m_EditSIPHeartBeatTimes.SetWindowText((LPCTSTR)Info.tInfo.m_cParam10);
		m_ChkSIPReg.SetCheck(atoi(Info.tInfo.m_cParam11));
		//m_CboSIPVideoChannelNum.AddString(_T("0"));
		//m_CboSIPVideoChannelNum.AddString(_T("1"));
		/*for (int i=0; i<DEC_MAX_CHANNEL_NUM_NEW; ++i)
		{
			char cTmp[16] = {0};
			sprintf(cTmp, "%d", i);
			m_CboSIPVideoChannelNum.AddString(_T(cTmp));
		}
		m_CboSIPVideoChannelNum.SetCurSel(0);*/
		iRet = CreateChannelCombo(m_lLogonID, &m_CboSIPVideoChannelNum);


 	//	int iChannelNO = m_CboSIPVideoChannelNum.GetCurSel();
		//if (0 == iChannelNO || 1 == iChannelNO)
		//{
		//	m_EditSIPVideoChannelID.SetWindowText((LPCTSTR)_pdecParam->m_SipVideoChannel.m_cChannelID[iChannelNO]);
		//}

		UpdateSipVideoChannelInfo();
	}

	GetPlatformInfo();
    return 0;
}
void CPageSettingSipAndPlatform::GetPlatformInfo(void)
{
	if (NULL == DEC_GetPlatformInfo)
	{
		return;
	}
	int iRet = DEC_GetPlatformInfo(m_lLogonID, &m_platFormInfo);
	if (iRet != 0)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
	}
	else
	{
		m_ListPlatformInfo.DeleteAllItems();
		for (int i = 0; i < m_platFormInfo.m_iCount; i++)
		{
			m_ListPlatformInfo.InsertItem(i, (LPCTSTR)m_platFormInfo.m_cPlatformName[i]);
		}
	}

	if (NULL == DEC_GetRunningPlatformInfo)
	{
		return;
	}
	iRet = DEC_GetRunningPlatformInfo(m_lLogonID, &m_runningPlatformInfo);
	if (iRet != 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK), _T(""), MB_OK|MB_TOPMOST);
	}
	else
	{
		m_ListRunning.DeleteAllItems();
		for (int i = 0; i < m_runningPlatformInfo.m_iCount; i++)
		{
			m_ListRunning.InsertItem(i, (LPCTSTR)m_runningPlatformInfo.m_cPlatformName[i]);
		}
	}

	if(0 == m_runningPlatformInfo.m_iCount)
	{
		::EnableWindow(GetDlgItem(IDC_BUTTON_STOPPLATFORM)->GetSafeHwnd(), FALSE);
	}
	else
	{
		::EnableWindow(GetDlgItem(IDC_BUTTON_STOPPLATFORM)->GetSafeHwnd(), TRUE);
	}

}
void CPageSettingSipAndPlatform::OnBnClickedButtonSetsip()
{
	// TODO: Add your control notification handler code here
	//жIPǷϷ
	CString szSIPserverIP = _T("");
	BYTE Field0, Field1, Field2, Field3;
	int NonBlank=this->m_SIPserverIP.GetAddress(Field0,Field1,Field2,Field3);
	if(NonBlank!=4)
	{
		MessageBox(GetText(IDS_MAIN_INVALID_IP), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	GetDlgItemText(IDC_IPADDRESS_SIPSERVERIP, szSIPserverIP);
	if(!IsValidIP(szSIPserverIP))
	{
		MessageBox(GetText(IDS_MAIN_INVALID_IP), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//жSIP˿ǷЧ
	CString szSIPserverPort = _T("");
	GetDlgItemText(IDC_EDIT_SIPSERVERPORT, szSIPserverPort);
	int iSIPserverPort = GetDlgItemInt(IDC_EDIT_SIPSERVERPORT, NULL, FALSE);
	if(iSIPserverPort > 65535 || iSIPserverPort <= 0)
	{
		//˿ںλʾ
		MessageBox(GetText(IDS_MAIN_INVALID_PORT), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//SIPIDǷҪ
	CString szSIPserverID = _T("");
	GetDlgItemText(IDC_EDIT_SIPSERVERID, szSIPserverID);
	if("" == szSIPserverID || strlen(szSIPserverID) > 32)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//SIP豸IDǷҪ
	CString szSIPDeviceID = _T("");
	GetDlgItemText(IDC_EDIT_SIPDEVICEID, szSIPDeviceID);
	if("" == szSIPDeviceID || strlen(szSIPDeviceID) > 32)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//SIPûǷϷ
	CString szSIPUserName = _T("");
	GetDlgItemText(IDC_EDIT_SIPUSERNAME, szSIPUserName);
	if("" == szSIPUserName || strlen(szSIPUserName) > 32)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	
	//SIPǷϷ
	CString szSIPPassword = _T("");
	GetDlgItemText(IDC_EDIT_SIPPWD, szSIPPassword);
	if("" == szSIPPassword || strlen(szSIPPassword) > 32)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//жעЧǷϷ
	CString szSIPRegValidity = _T("");
	GetDlgItemText(IDC_EDIT_SIPVALIDDATE, szSIPRegValidity);
	if("" == szSIPRegValidity || strlen(szSIPRegValidity) > 10)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//жϱʱǷϷ
	CString szSIPKeepalive = _T("");
	GetDlgItemText(IDC_EDIT_SIPTIME, szSIPKeepalive);
	if("" == szSIPKeepalive || strlen(szSIPKeepalive) > 5)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//жǷϷ
	CString szSIPHeartBeatInterval = _T("");
	GetDlgItemText(IDC_EDIT_SIPHEART, szSIPHeartBeatInterval);
	if ("" == szSIPHeartBeatInterval || strlen(szSIPHeartBeatInterval) > 5)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//жǷϷ
	CString szSIPHeartBeatTimes = _T("");
	GetDlgItemText(IDC_EDIT_HEARTNUM, szSIPHeartBeatTimes);
	if ("" == szSIPHeartBeatTimes || strlen(szSIPHeartBeatTimes) > 5)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//ýӿڣ
	DZ_INFO_PARAM vDZInfoSIP = {0};
	strcpy_s(vDZInfoSIP.m_cParam1, sizeof(vDZInfoSIP.m_cParam1), (LPSTR)(LPCTSTR)szSIPserverIP);
	strcpy_s(vDZInfoSIP.m_cParam2, sizeof(vDZInfoSIP.m_cParam2), (LPSTR)(LPCTSTR)szSIPserverPort);
	strcpy_s(vDZInfoSIP.m_cParam3, sizeof(vDZInfoSIP.m_cParam3), (LPSTR)(LPCTSTR)szSIPserverID);
	strcpy_s(vDZInfoSIP.m_cParam4, sizeof(vDZInfoSIP.m_cParam4), (LPSTR)(LPCTSTR)szSIPDeviceID);
	strcpy_s(vDZInfoSIP.m_cParam5, sizeof(vDZInfoSIP.m_cParam5), (LPSTR)(LPCTSTR)szSIPUserName);
	strcpy_s(vDZInfoSIP.m_cParam6, sizeof(vDZInfoSIP.m_cParam6), (LPSTR)(LPCTSTR)szSIPPassword);
	strcpy_s(vDZInfoSIP.m_cParam7, sizeof(vDZInfoSIP.m_cParam7), (LPSTR)(LPCTSTR)szSIPRegValidity);
	strcpy_s(vDZInfoSIP.m_cParam8, sizeof(vDZInfoSIP.m_cParam8), (LPSTR)(LPCTSTR)szSIPKeepalive);
	strcpy_s(vDZInfoSIP.m_cParam9, sizeof(vDZInfoSIP.m_cParam9), (LPSTR)(LPCTSTR)szSIPHeartBeatInterval);
	strcpy_s(vDZInfoSIP.m_cParam10, sizeof(vDZInfoSIP.m_cParam10), (LPSTR)(LPCTSTR)szSIPHeartBeatTimes);
	vDZInfoSIP.m_cParam11[0] = m_ChkSIPReg.GetCheck() + '0';

	int iRet = DEC_SetDZInfo(m_lLogonID, &vDZInfoSIP);
	if (iRet == 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
}

void CPageSettingSipAndPlatform::OnBnClickedButtonSetchannel()
{
	CString szSIPVideoChannelID = _T("");
	GetDlgItemText(IDC_EDIT_CHANNELNO, szSIPVideoChannelID);
	if("" == szSIPVideoChannelID || strlen(szSIPVideoChannelID) > 32)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	char cID[DEC_LEN_32 + 1] = {0};
	strcpy_s(cID, sizeof(cID), (LPSTR)(LPCTSTR)szSIPVideoChannelID);
	for(unsigned int i = 0; i < strlen(cID); i++)
	{
		if (cID[i] < '0' || cID[i] > '9')    //IDֻΪ
		{
			MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
			return;
		}
	}

	TSetSipVideoChannel svc = {0};   
	svc.m_iChannelNo = GetComboData(&m_CboSIPVideoChannelNum);;
	strcpy_s(svc.m_cChannelID, sizeof(svc.m_cChannelID), (LPSTR)(LPCTSTR)szSIPVideoChannelID);
	int iRet = DEC_SetChannelSipConfig(m_lLogonID, SIP_CMD_SET_VIDEOCHANNEL, &svc);
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK), _T(""), MB_OK|MB_TOPMOST);
	}
}

void CPageSettingSipAndPlatform::OnBnClickedButtonStartplatform()
{
	if (NULL == DEC_SetPlatformStart)
	{
		return;
	}
	/*if (0 != m_runningPlatformInfo.m_iCount)
	{
		MessageBox(GetText(IDS_SETTING_PLAT_ALREADY_START), _T(""), MB_OK|MB_TOPMOST);
		return;
	}*/
	if (0 == m_ListPlatformInfo.GetItemCount())
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	int iRunNum = m_ListRunning.GetItemCount();


	TPLATFORMINFO platformInfo = {0};

 	int i = 0;
	POSITION pos = m_ListPlatformInfo.GetFirstSelectedItemPosition();
	if (pos == NULL)
	{
		//ûѡѡ
		MessageBox(GetText(IDS_SETTING_INVALIDPARA), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	else
	{
		while (pos)
		{
			if (i > 9)
			{
				break;
			}
			int nItem = m_ListPlatformInfo.GetNextSelectedItem(pos);
			TRACE(_T("Item %d was selected!\n"), nItem);
			CString sztemp = m_ListPlatformInfo.GetItemText(nItem,0);
			if(CompareItem(sztemp, &m_ListRunning))
				continue;
			strcpy_s(platformInfo.m_cPlatformName[i], sizeof(platformInfo.m_cPlatformName[i]),(LPSTR)(LPCTSTR)sztemp);
			i++;
		}
	}

	for(int j = 0; j< iRunNum; j++)
	{
		CString sztemp = m_ListRunning.GetItemText(j,0);
		strcpy_s(platformInfo.m_cPlatformName[i++], sizeof(platformInfo.m_cPlatformName[i++]),(LPSTR)(LPCTSTR)sztemp);
	}

	platformInfo.m_iCount = i;
	int iRet = DEC_SetPlatformStart(m_lLogonID, &platformInfo);
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK), _T(""), MB_OK|MB_TOPMOST);
	}
}

void CPageSettingSipAndPlatform::OnBnClickedButtonStopplatform()
{
	if (NULL == DEC_SetPlatformStart)
	{
		return;
	}
	TPLATFORMINFO platformInfo = {0};
	int iRun = 0;
	int iPos = 0;
	int iState = -1;
	int iCount = m_ListRunning.GetItemCount();
	for (iPos = 0; iPos < iCount; iPos++)
	{
		//ûѡĸЭ
		iState = m_ListRunning.GetItemState(iPos, LVIS_SELECTED);
		if(0 == iState)
		{
			CString sztemp = m_ListRunning.GetItemText(iPos,0);
			strcpy_s(platformInfo.m_cPlatformName[iRun], sizeof(platformInfo.m_cPlatformName[iRun]),(LPSTR)(LPCTSTR)sztemp);
			iRun++;
		}
	}
	platformInfo.m_iCount = iRun;
	int iRet = DEC_SetPlatformStart(m_lLogonID, &platformInfo);
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK), _T(""), MB_OK|MB_TOPMOST);
	}

}

void CPageSettingSipAndPlatform::OnBnClickedButtonRefreash()
{
	GetPlatformInfo();
}

void CPageSettingSipAndPlatform::OnCbnSelchangeComboChannel()
{
	//int iChannelNo = m_CboSIPVideoChannelNum.GetCurSel();
	//TDECPARAM decParam = {0};
	//int iRet = DEC_ClientGetDecoderPara(m_lLogonID, &decParam); //»ȡһ豸Ϣˢһ£
	//if (0 == iRet)
	//{
	//	m_EditSIPVideoChannelID.SetWindowText((LPCTSTR)decParam.m_SipVideoChannel.m_cChannelID[iChannelNo]);
	//}
	//else
	//{
	//	OutputDebugString(_T("DEC_ClientGetDecoderPara failed......"));
	//}

	UpdateSipVideoChannelInfo();
}

BOOL CPageSettingSipAndPlatform::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingSipAndPlatform::UpdateSipVideoChannelInfo()
{
	int iChannelNo = GetComboData(&m_CboSIPVideoChannelNum);
	SipVideoChannel tSipVideo = {0};
	tSipVideo.iSize = sizeof(SipVideoChannel);

	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannelNo, 0, CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX, &tSipVideo, sizeof(SipVideoChannel));
	if (ERR_SUCCESS == iRet)
	{
		m_EditSIPVideoChannelID.SetWindowText((LPCTSTR)tSipVideo.cChannelID);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingSipAndPlatform::UpdateSipVideoChannelInfo] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX);
	}
}


bool CPageSettingSipAndPlatform::CompareItem(CString sCompare, CListCtrl* list2)
{
	int iListNum = list2->GetItemCount();
	CString sTemp = "";
	for(int i = 0;i < iListNum; i++)
	{
		sTemp = list2->GetItemText(i,0);
		if(sTemp == sCompare)
		{
			return true;
		}

	}
	return false;
}